package w83b.w83bUtilidades;

import java.io.IOException;
import java.util.HashMap;

import org.apache.commons.lang.StringUtils;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import w83b.w83bBeans.W83bCitacionBean;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidades.W83bUtilidadesRTF;

/**
 * 
 * @author 
 *
 */
public abstract class W83bUtilidadesCitaciones{

	public static StringBuffer elementoCentroTrabajoMesaImpugnante(int numElemEspecial,
			W83bCitacionBean citacion, StringBuffer datosp, StringBuffer contenidoBuffer, StringBuffer contenidoBufferCorto, HashMap mapaPar,int i,String idioma) throws IOException, Q70GestorMensajesException 
	{
		StringBuffer datos=datosp;
		StringBuffer elemento=new StringBuffer(W83bClsConstantes.CUARENTA);
		int numElem=i;
		String razon=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getRazonSocial());
		String razonSalto=W83bUtilidadesRTF.meterIntroEtiquetas(razon,0,3);
		String direccion="";
		String direccionSalto;
		int numsaltosRazon=W83bUtilidadesRTF.numIntros(razonSalto);
		int numsaltosDireccion=0;
		String cp="";
		String munic="";
		
		//primer elemento el correspondiente a la empresa asociada a la impugnacion, se le enviara a la direccion indicada en la citacion.
		if(citacion.getCentroSel().equals(W83bClsConstantes.CONSTANTE_NO_VALIDADA))
		{
			
			if(numElemEspecial==7)
			{
				direccion=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getDomicilio());
				direccionSalto=W83bUtilidadesRTF.meterIntroEtiquetas(direccion,0,3);
				numsaltosDireccion=W83bUtilidadesRTF.numIntros(direccionSalto);
			}else{
				razonSalto=razon;
				direccionSalto=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getDomicilio());
			}
			
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(razonSalto));//citacion.getCentroTrabajo().getRazonSocial()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(direccionSalto));
			cp=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getCodPostal());
			mapaPar.put("<<CPOST>>",cp);
			munic=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getMunicipio());
			if (!("").equals(cp.trim())&&!("").equals(munic.trim())){
				mapaPar.put("<<LOCAL>>","-"+munic);
			}
			else{
				mapaPar.put("<<LOCAL>>",munic);
			}
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getTerritorio()));
		}else if(citacion.getCentroSel().equals(W83bClsConstantes.CONSTANTE_VALIDADA))
		{
			if(numElemEspecial==7)
			{
				direccion=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getDomicilio());
				direccionSalto=W83bUtilidadesRTF.meterIntroEtiquetas(direccion,0,3);
				numsaltosDireccion=W83bUtilidadesRTF.numIntros(direccionSalto);
			}else{
				razonSalto=razon;
				direccionSalto=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getDomicilio());
			}
			
			
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(razonSalto));//citacion.getCentroTrabajo().getRazonSocial()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(direccionSalto));
			cp=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getCodPostal());
			mapaPar.put("<<CPOST>>",cp);
			munic=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getMunicipio());
			if (!("").equals(cp.trim())&&!("").equals(munic.trim())){
				mapaPar.put("<<LOCAL>>","-"+munic);
			}
			else{
				mapaPar.put("<<LOCAL>>",munic);
			}
			
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getTerritorio()));
		}
		
		elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
		if(numElemEspecial==7)
		{
			
			if(numsaltosRazon>0)
			{
				String s="";
				int inicioS=0;
				if(numElem%numElemEspecial==0)
				{
					if(numsaltosRazon==W83bClsConstantes.UNO)
					{
						s="\\par \\par";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"\\par ");
					}else if(numsaltosRazon==W83bClsConstantes.DOS)
					{
						s="\\par \\par";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"");
					}
					
				}
				else{
					if(numsaltosRazon==W83bClsConstantes.UNO)
					{
						s="\\par \\par \\par \\par \\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"\\par \\par \\par \\par ");
					}else if(numsaltosRazon==W83bClsConstantes.DOS)
					{
						s="\\par \\par \\par \\par \\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"\\par \\par \\par ");
					}
					
				}

				
				
			}
			if(numsaltosDireccion>0)
			{
				String s="";
				int inicioS=0;
				
				if(numElem%numElemEspecial==0)
				{
					if(numsaltosDireccion==W83bClsConstantes.UNO)
					{
						s="\\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"");
					}else if(numsaltosDireccion==W83bClsConstantes.DOS)
					{
						s="\\par \\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"");
					}
					
				}
				else{
					if(numsaltosDireccion==W83bClsConstantes.UNO)
					{
						s="\\par \\par \\par \\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"\\par \\par \\par ");
					}else if(numsaltosDireccion==W83bClsConstantes.DOS)
					{
						s="\\par \\par \\par \\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"\\par \\par ");
					}
					
				}

				
				
			}
			
		}
		datos.append(elemento);
		numElem++;
		/*segundo elemento, si la citacion tiene la comunicacion a la mesa activada , la direccion sera la propia de la empresa,
		 *  pero la razon social sera "Mesa Electoral"
		 */
		
		if(citacion.getMesa().equals(W83bClsConstantes.CONSTANTE_VALIDADA))
		{
			mapaPar.put("<<RAZON>>",Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.comunicacion.mesaElectoral",idioma));
			//resto del mapa es el mismo que la empresa
			elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			datos.append(elemento);
			numElem++;
		}
		
		
		
		/*tercer elemento impugnante si es que lo tiene
		 */
		
		if(StringUtils.isNotEmpty(citacion.getDniImpug()))
			
		{  
			razon=W83bUtilidades.convertirAVasioSiNulo(citacion.getNombreImpug());
			direccion=W83bUtilidades.convertirAVasioSiNulo(citacion.getDirImpug());
			
			if(numElemEspecial==7)
			{
				razonSalto=W83bUtilidadesRTF.meterIntroEtiquetas(razon,1,3);
				direccionSalto=W83bUtilidadesRTF.meterIntroCarpeta(direccion,1,3);
			}else{
				razonSalto=razon;
				direccionSalto=direccion;
			}
			
			
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(razonSalto));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(direccionSalto));
			cp=W83bUtilidades.convertirAVasioSiNulo(citacion.getCpImpug());
			mapaPar.put("<<CPOST>>",cp);
			munic=W83bUtilidades.convertirAVasioSiNulo(citacion.getCpImpug());
			if (!("").equals(cp)&&!("").equals(munic)){
				mapaPar.put("<<LOCAL>>","-"+munic);
			}
			else{
				mapaPar.put("<<LOCAL>>",munic);
			}
			
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getProvinciaImpugTxtC()));
			
			// si es el elemento es el 3 multiple de 3 hay que retocar el contenido
			//quitar 7 saltos de linea
			
			if(numElem%numElemEspecial==0)
			{
				
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBufferCorto, mapaPar);
				
			}else{
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			}
			
			if(numElemEspecial==7)
			{
				if(numsaltosRazon>0 )
				{
					String s="";
					int inicioS=0;
					
					if(numElem%numElemEspecial==0)
					{
						s="\\par \\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"\\par ");
					}
					else{
						s="\\par \\par \\par \\par \\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"\\par \\par \\par \\par ");
					}

					
					
				}
				if(numsaltosDireccion>0)
				{
					String s="";
					int inicioS=0;
					
					if(numElem%numElemEspecial==0)
					{
						s="\\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"");
					}
					else{
						s="\\par \\par \\par \\par ";
						inicioS=elemento.lastIndexOf(s);
						elemento.replace(inicioS,inicioS+s.length(),"\\par \\par \\par ");
					}

					
					
				}
				
			}
			
			datos.append(elemento);
			numElem++;
			
		}
		return datos;
	}

	public static StringBuffer elementoSindicatos(int numElemEspecial,
			W83bCitacionBean citacion, StringBuffer datosp, StringBuffer contenidoBuffer, StringBuffer contenidoBufferCorto, HashMap mapaPar,int j,HashMap txtMuniProv) throws IOException, Q70GestorMensajesException 
	{
		StringBuffer datos=datosp;
		StringBuffer elemento=new StringBuffer(W83bClsConstantes.CUARENTA);
		int numElem=j;
		// mas  Z elementos tantos como impugnaciones relacionadas tenga, bien sean mayoritarios, de la impugnacion o adicionales
		String [] cods=citacion.getCodsSindicatos().split(",");
		String [] siglas=citacion.getSiglasSindicatos().split(", ");
		String [] dir=citacion.getDirSindicatos().split(",");
		String [] cps=citacion.getCpSindicatos().split(",");
		String [] munisC=(String[])txtMuniProv.get("txtMunicipiosC");
		String [] provsC=(String[])txtMuniProv.get("txtTerritoriosC");
		
		String munic="";
		String cp="";
		
		for(int i=0;i<cods.length;i++)
		{
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(siglas[i]));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNuloArray(dir,i));
			cp=W83bUtilidades.convertirAVasioSiNuloArray(cps,i);
			mapaPar.put("<<CPOST>>",cp);
			munic=W83bUtilidades.convertirAVasioSiNuloArray(munisC,i);
			if (!("").equals(munic.trim())&&!("").equals(cp.trim())){
				mapaPar.put("<<LOCAL>>","-"+munic);
			}
			else{
				mapaPar.put("<<LOCAL>>",munic);
			}
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNuloArray(provsC,i));
			
			// si es el elemento es el 3 multiple de 3 hay que retocar el contenido
			//quitar 7 saltos de linea
			
			if(numElem%numElemEspecial==0)
			{
				
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBufferCorto, mapaPar);
				
			}else{
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			}
			
		
			datos.append(elemento);
			numElem++;
		}
		return datos;
	}

	
}


